/******************************************************************************
 * %Id: 
 *
 * FileName		:od_bridge_data.h
 *
 * Description	:Definition header of data used in bridge
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_OD_BRIDGE_DATA_H_
#define	_OD_BRIDGE_DATA_H_

#include <linux/iosc/iosc-devices.h>

#define OD_MAX_FD_NAME       256
#define OD_TH_DATA_NUM        15

/*LUTDATE SIZE 8bit * 17 * 16 /32bit -> 64word*/
#define OD_LUT_DATA_LEN       68

/*
 * Sub Structs
 */
typedef struct {
    unsigned short h_offset;
    unsigned short v_offset;
    unsigned short h_width;
    unsigned short v_width;
    unsigned char format;
} od_signal_form_t;

typedef struct {
    unsigned short r_satlo;
    unsigned short r_sathi;
    unsigned short g_satlo;
    unsigned short g_sathi;
    unsigned short b_satlo;
    unsigned short b_sathi;
    unsigned short wh_ratio;
} od_ecnp_threshold_param_t;

typedef struct {
	unsigned char mode;
	unsigned long r[OD_LUT_DATA_LEN];
	unsigned long g[OD_LUT_DATA_LEN];
	unsigned long b[OD_LUT_DATA_LEN];
} od_lut_t;

/*
 * Main Structures
 */
typedef struct {
    int cmd;
    int (*handler) (int, unsigned int, void *);
} od_command_t;

typedef struct _od_arg_t {
    int error;
} od_arg_t;

typedef struct _od_status_arg_t {
    int error;
    unsigned char state;
} od_status_arg_t;

typedef struct _od_signal_form_arg_t {
    int error;
    od_signal_form_t param;
} od_signal_form_arg_t;

typedef struct _od_thparam_arg_t {
    int error;
    unsigned char nonlmd;
    unsigned short data[OD_TH_DATA_NUM];
} od_thparam_arg_t;

typedef struct _od_lut_arg_t {
    int error;
    od_lut_t param;
} od_lut_arg_t;


#endif                          /* _OD_BRIDGE_DATA_H_ */

/* end of od_bridge_data.h */
